float4x4 matView;
float4x4 matProjection;
float4x4 matViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float4x4 matWorldViewProjection;
float4x4 matMirror;

float time; 
float const0;
float const1;

float3 CameraPosition;
float3 CameraTarget;

bool    usealpha;
texture tex0;
texture tex1;
texture tex2;

sampler sTex0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex2 = sampler_state
{
	texture = (tex2);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

struct VS_INPUT 
{
	float4 pos : POSITION;
	float3 norm : NORMAL;
	float2 tex0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos : POSITION;
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
	float4 diffuse : COLOR0;
};

VS_OUTPUT DiscoCylinderBaseVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex0.x = (i.tex0.x*.001f)+time*.1f;//+(i.pos.y*1.f);
	o.tex0.y = (i.tex0.y)+time*.1f;
	
//	o.tex1.y = i.tex0.y*40.f;
//	o.tex1.x = i.tex0.x*12.f;
	
	float3 tn = mul(i.norm, matWorldView);
	o.tex1.y = tn.y;
	o.tex1.x = tn.z;
		
	float3 transformedpos = mul(i.pos, matWorld);
	o.diffuse.r = transformedpos.x*.001f;
	o.diffuse.agb = 1.f;
	return o;
}

VS_OUTPUT PlaneVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex0.y = (i.tex0.y/19.f)+(const0/18.f);
	o.tex0.x = i.tex0.x;
	o.tex1 = i.tex0;
	
	i.pos.x -= 200.f;
	float3 transformedpos = mul(i.pos, matWorldView);
	o.diffuse.r = transformedpos.x*.001f;
	o.diffuse.agb = 1.f;
	
	//o.diffuse = float4(1.f, 1.f, 1.f, 1.f);
	return o;
}

VS_OUTPUT DiscoCylinderFinVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);

	o.tex0 = i.tex0;
	o.tex1.y = i.tex0.y*40.f-(time*4.f);
	o.tex1.x = i.tex0.x*12.f;
		
	float3 transformedpos = mul(i.pos, matWorld);
	o.diffuse.r = transformedpos.x*.001f;
	o.diffuse.agb = 1.f;
	return o;
}

struct PS_INPUT
{
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
	float4 diffuse : COLOR0;
};

float4 PlanePS(PS_INPUT i) : COLOR0
{
	float4 color = tex2D(sTex0, float2(i.tex0.x, i.tex0.y));
	color.rgb *= (1.f-i.diffuse.r);
	return color;
}

float4 DiscoCylinderBasePS(PS_INPUT i) : COLOR0
{
	float4  color = tex2D(sTex1, i.tex1);
	float4 base = tex2D(sTex0, i.tex0);
	base.rgb += color.rgb;
	return base *(1-i.diffuse.r);
}

float4 DiscoCylinderFinPS(PS_INPUT i) : COLOR0
{
	float4  color = tex2D(sTex0, i.tex1);
	return color *(1-i.diffuse.r);
}

/////////////////////////////////////////////////////////////

technique DiscoCylinder
{
	pass p1
	{
		VertexShader = compile vs_2_0 DiscoCylinderBaseVS();
		PixelShader  = compile ps_2_0 DiscoCylinderBasePS();
	}
	pass p2
	{
		VertexShader = compile vs_2_0 DiscoCylinderFinVS();
		PixelShader  = compile ps_2_0 DiscoCylinderFinPS();
	}
}

technique Plane01
{
	pass p1
	{
		VertexShader = compile vs_2_0 PlaneVS();
		PixelShader  = compile ps_2_0 PlanePS();
	}
}